/**************************************************************************/
/* FILE NAME: eMIOS_setup.c               COPYRIGHT (c) Freescale 2006 	  */
/*                                                All Rights Reserved     */
/* DESCRIPTION:                                                           */
/* This file contains the necessary setup code for configuring the eMIOS  */
/* for GPIO mode on CH0 and OPWM mode on CH5.							  */
/*========================================================================*/
/* REV      AUTHOR       DATE       DESCRIPTION OF CHANGE                 */
/* ---   -----------   ----------   ---------------------                 */
/* 0.1   D.Mcmenamin    27/Oct/06	Inital version						  */
/* 0.2   D.Paterson     01/Feb/07    Integrated to multi-mod test         */
/**************************************************************************/ 
#include "mpc5561.h"

#define eMIOS0_PIN		179
#define eMIOS5_PIN		184

void setup_emios_PCR(void);
 
/**************************************************************************/
/* FUNCTION     : setup_emios										      */
/* PURPOSE      : Configures the eMIOS for GPIO mode on CH0 and OPWM mode */
/*				  on CH5.									              */
/**************************************************************************/  
void setup_eMIOS(void) {
	
	setup_emios_PCR();
	
	/* Configure eMIOS MCR- GTBE,GPREN, GPRE 100 */
 	EMIOS.MCR.R = 0x14006400;	
  	
 	/* Configure channel 23 - Mod Up Counter PRE=1 */
 	EMIOS.CH[23].CCR.R = 0x02000050;
 	
 	/* Set Max up count value: 0x5000 = 2560 */
 	EMIOS.CH[23].CADR.R = 0x5000; //0x5000;
 	
 	/* Configure Channel 0 - GP INPUT - Rising edge trigger */
 	EMIOS.CH[0].CCR.R = 0x02000080;
 	
 	/* Configure Channel 5 - OPWM, BUS A, EDPOL=1, PRE=0 */
 	EMIOS.CH[5].CCR.R = 0x020000E0;
 	
 	EMIOS.CH[5].CADR.R = 0x2800; //0x2800;
	EMIOS.CH[5].CBDR.R = 0x5000; //0x5000;	//Set up fo 16ms rising edge to rising edge
  
	/* Enable interrupt for Channel 0 */
 	EMIOS.CH[0].CCR.B.DMA = 0x0;
	EMIOS.CH[0].CCR.B.FEN = 0x1;
}
 
/**************************************************************************/
/* FUNCTION     : setup_emios_PCR										  */
/* PURPOSE      : Configures the PCRs for eMIOS Ch0 and Ch5               */
/**************************************************************************/ 
void setup_emios_PCR(void) {
	
	/* OBE=OFF, IBE=ON, Primary mode*/
	SIU.PCR[eMIOS0_PIN].R = 0x0500;
	
	/* OBE=ON, IBE=ON, Primary mode*/
	SIU.PCR[eMIOS5_PIN].R = 0x0600;

}